<?php

// myaddrdir_modify.php3
require('myaddrdir_common.php3');
require('myaddrdir_functions.php3');


if (!isset($firstCall)) {
   $searchFilter = "(mail=*" . urldecode($mail) . "*)";

   $linkIdentifier = ConnectBindServer();
   if ($linkIdentifier) {
      $resultEntry = SearchDirectory($linkIdentifier, $searchFilter);

   } else {
      DisplayErrMsg("Connection to LDAP server failed !!");  
   }

   GenerateHTMLHeader("Please modify fields: (E-mail should not be modified)");

   GenerateHTMLForm($resultEntry, "myaddrdir_modify.php3", "MODIFY");

   CloseConnection($linkIdentifier);

} else {
   $dnString = "mail=" . $mail . "," .$baseDN;

   $newEntry["dn"]              = $dnString;
   $newEntry["cn"]              = $cn;
   $newEntry["locality"]        = $locality;
   $newEntry["description"]     = $description;
   $newEntry["telephonenumber"] = $telephonenumber;

   $linkIdentifier = ConnectBindServer();
   if ($linkIdentifier) {
      if ((ldap_modify($linkIdentifier, $dnString, $newEntry)) == false) {
         DisplayErrMsg("LDAP directory modification failed !!");
         CloseConnection($linkIdentifier);
         exit;
      } else {
         GenerateHTMLHeader("The entry was modified succesfully");
         ReturnToMain();
      }
   } else {
      DisplayErrMsg("Connection to LDAP server failed");
      exit;
   }
}

?>
